/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.function.Supplier;
import mcjty.lib.blockcommands.ICommand;
import mcjty.lib.network.PacketDataFromServer;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketRequestDataFromServer {
    protected BlockPos pos;
    private final ResourceKey<Level> type;
    protected String command;
    protected TypedMap params;
    private final boolean dummy;

    public PacketRequestDataFromServer(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.type = LevelTools.getId(buf.m_130281_());
        this.command = buf.m_130136_(Short.MAX_VALUE);
        this.params = TypedMapTools.readArguments(buf);
        this.dummy = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130085_(this.type.m_135782_());
        buf.m_130070_(this.command);
        TypedMapTools.writeArguments(buf, this.params);
        buf.writeBoolean(this.dummy);
    }

    public PacketRequestDataFromServer(ResourceKey<Level> type, BlockPos pos, String command, TypedMap params, boolean dummy) {
        this.type = type;
        this.pos = pos;
        this.command = command;
        this.params = params;
        this.dummy = dummy;
    }

    public PacketRequestDataFromServer(ResourceKey<Level> type, BlockPos pos, ICommand command, TypedMap params, boolean dummy) {
        this.type = type;
        this.pos = pos;
        this.command = command.name();
        this.params = params;
        this.dummy = dummy;
    }

    public void handle(SimpleChannel channel, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerLevel world = LevelTools.getLevel(ctx.getSender().m_20193_(), this.type);
            if (world.m_46805_(this.pos)) {
                GenericTileEntity generic;
                TypedMap result;
                BlockEntity patt2556$temp = world.m_7702_(this.pos);
                if (patt2556$temp instanceof GenericTileEntity && (result = (generic = (GenericTileEntity)patt2556$temp).executeServerCommandWR(this.command, (Player)ctx.getSender(), this.params)) != null) {
                    PacketDataFromServer msg = new PacketDataFromServer(this.dummy ? null : this.pos, this.command, result);
                    channel.sendTo((Object)msg, ctx.getSender().f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                    return;
                }
                Logging.log("Command " + this.command + " was not handled!");
            }
        });
        ctx.setPacketHandled(true);
    }
}

